//
//  AdConfiguration.h
//  dJAX
//
//  Copyright (c) 2012 dJAX, Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "Global.h"

@class dJAXRewardedVideoReward;

enum {
    dJAXAdTypeUnknown = -1,
    dJAXAdTypeBanner = 0,
    dJAXAdTypeInterstitial = 1
};
typedef NSUInteger dJAXAdType;

extern NSString * const kdJAXAdTypeHeaderKey;
extern NSString * const kdJAXAdUnitWarmingUpHeaderKey;
extern NSString * const kdJAXClickthroughHeaderKey;
extern NSString * const kdJAXCreativeIdHeaderKey;
extern NSString * const kdJAXCustomSelectorHeaderKey;
extern NSString * const kdJAXCustomEventClassNameHeaderKey;
extern NSString * const kdJAXCustomEventClassDataHeaderKey;
extern NSString * const kdJAXFailUrlHeaderKey;
extern NSString * const kdJAXHeightHeaderKey;
extern NSString * const kdJAXImpressionTrackerHeaderKey;
extern NSString * const kdJAXInterceptLinksHeaderKey;
extern NSString * const kdJAXLaunchpageHeaderKey;
extern NSString * const kdJAXNativeSDKParametersHeaderKey;
extern NSString * const kdJAXNetworkTypeHeaderKey;
extern NSString * const kdJAXRefreshTimeHeaderKey;
extern NSString * const kdJAXAdTimeoutHeaderKey;
extern NSString * const kdJAXScrollableHeaderKey;
extern NSString * const kdJAXWidthHeaderKey;
extern NSString * const kdJAXDspCreativeIdKey;
extern NSString * const kdJAXPrecacheRequiredKey;
extern NSString * const kdJAXIsVastVideoPlayerKey;
extern NSString * const kRewardedVideoCurrencyNameHeaderKey;
extern NSString * const kRewardedVideoCurrencyAmountHeaderKey;
extern NSString * const kRewardedVideoCompletionUrlHeaderKey;
extern NSString * const kRewardedCurrenciesHeaderKey;
extern NSString * const kRewardedPlayableDurationHeaderKey;
extern NSString * const kRewardedPlayableRewardOnClickHeaderKey;

extern NSString * const kdJAXInterstitialAdTypeHeaderKey;
extern NSString * const kdJAXOrientationTypeHeaderKey;

extern NSString * const kdJAXAdTypeHtml;
extern NSString * const kdJAXAdTypeInterstitial;
extern NSString * const kdJAXAdTypeMraid;
extern NSString * const kAdTypeClears;
extern NSString * const kdJAXAdTypeNative;
extern NSString * const kdJAXAdTypeNativeVideo;

@interface AdConfiguration : NSObject

@property (nonatomic, assign) dJAXAdType adType;
@property (nonatomic, assign) BOOL adUnitWarmingUp;
@property (nonatomic, copy) NSString *networkType;
@property (nonatomic, assign) CGSize preferredSize;
@property (nonatomic, strong) NSURL *clickTrackingURL;
@property (nonatomic, strong) NSURL *impressionTrackingURL;
@property (nonatomic, strong) NSURL *failoverURL;
@property (nonatomic, strong) NSURL *interceptURLPrefix;
@property (nonatomic, assign) BOOL shouldInterceptLinks;
@property (nonatomic, assign) BOOL scrollable;
@property (nonatomic, assign) NSTimeInterval refreshInterval;
@property (nonatomic, assign) NSTimeInterval adTimeoutInterval;
@property (nonatomic, copy) NSData *adResponseData;
@property (nonatomic, strong) NSDictionary *nativeSDKParameters;
@property (nonatomic, copy) NSString *customSelectorName;
@property (nonatomic, assign) Class customEventClass;
@property (nonatomic, strong) NSDictionary *customEventClassData;
@property (nonatomic, assign) dJAXInterstitialOrientationType orientationType;
@property (nonatomic, copy) NSString *dspCreativeId;
@property (nonatomic, assign) BOOL precacheRequired;
@property (nonatomic, assign) BOOL isVastVideoPlayer;
@property (nonatomic, strong) NSDate *creationTimestamp;
@property (nonatomic, copy) NSString *creativeId;
@property (nonatomic, copy) NSString *headerAdType;
@property (nonatomic, assign) NSInteger nativeVideoPlayVisiblePercent;
@property (nonatomic, assign) NSInteger nativeVideoPauseVisiblePercent;
@property (nonatomic, assign) NSInteger nativeVideoImpressionMinVisiblePercent;
@property (nonatomic, assign) NSTimeInterval nativeVideoImpressionVisible;
@property (nonatomic, assign) NSTimeInterval nativeVideoMaxBufferingTime;
@property (nonatomic) NSDictionary *nativeVideoTrackers;
@property (nonatomic, readonly) NSArray *availableRewards;
@property (nonatomic, strong) dJAXRewardedVideoReward *selectedReward;
@property (nonatomic, copy) NSString *rewardedVideoCompletionUrl;
@property (nonatomic, assign) NSTimeInterval rewardedPlayableDuration;
@property (nonatomic, assign) BOOL rewardedPlayableShouldRewardOnClick;

- (id)initWithHeaders:(NSDictionary *)headers data:(NSData *)data;

- (BOOL)hasPreferredSize;
- (NSString *)adResponseHTMLString;
- (NSString *)clickDetectionURLPrefix;

@end
